﻿
<%@ Page language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="ec" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Core" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

	protected void dc_ContextLoad(object sender, EventArgs e)
	{
		var raportyOperatorow = new List<RaportWgOperatora>();
        foreach (Operator op in param.Operators) {
            raportyOperatorow.Add(new RaportWgOperatora(op, param.DBItems, param.Okres));
        }

        if (param.Grupowanie == Params.GrupowanieWg.BazDanych) {
            ReportHeader1.Title = string.Format(ReportHeader1.Title, param.Okres, "baz danych");        
            FirstColumn.Caption = "Operator";
            FirstColumn.DataMember = "Operator";
            DataRepeater1.RowTypeName = "";
            labelOperator.DataMember = "DBItem";
            DataRepeater1.DataSource = GetRaportyBaz(raportyOperatorow);
        }
        else {
            ReportHeader1.Title = string.Format(ReportHeader1.Title, param.Okres, "operatorów");        
            DataRepeater1.DataSource = raportyOperatorow;
        }
	}
    
    static List<RaportWgBazy> GetRaportyBaz(List<RaportWgOperatora> raportyOperatorow)
    {
        var result = new List<RaportWgBazy>();

        foreach (RaportWgOperatora raport in raportyOperatorow) {
            foreach (RaportBazy item in raport.RaportyBaz) {
                RaportWgBazy rp = result.FirstOrDefault(p => p.DBItem == item.DBItem.ToString());
                if (rp == null) {
                    rp = new RaportWgBazy(item.DBItem.ToString(), new List<RaportBazy>());
                    result.Add(rp);
                }
                rp.AddRaport(item);
            }
        }        
        
        return result;
    }

	Params param = null;

	[Context]
	public Params Param {
		set { param = value; }
	}

    public class RaportWgBazy
    {
        private List<RaportBazy> raportyBaz;
        
        public RaportWgBazy(string DBItem, List<RaportBazy> raportyBaz)
        {
            this.DBItem = DBItem;
            this.raportyBaz = raportyBaz;
        }
        
        public void AddRaport(RaportBazy rp)
        {
            raportyBaz.Add(rp);
        }
        
        public string DBItem { get; private set; }

        public RaportBazy[] RaportyBaz { get { return raportyBaz.ToArray(); } }
    }
        
	public class RaportWgOperatora 
    {
        public RaportWgOperatora(Operator op, DBItem[] dbitems, FromTo okres)
        {
            this.op = op;
            foreach (var dbi in dbitems) {
                using (var db = dbi.GetDatabase()) {
                    if (db.State != DatabaseState.OK) return;

                    var raport = new RaportBazy { DBItem = dbi };

                    using (var session = db.Login(op.Session.Login).CreateSession(true, false, "RaportOperatora")) {
                        var opdb = BusinessModule.GetInstance(session).Operators.ByName[op.Name];
                        if (opdb == null) continue;

                        raport.Operator = op.ToString();

                        raport.Zakup =
                            GetCount(session, "DokEwidencja",
                                new FieldCondition.Equal("Typ", Soneta.Core.TypDokumentu.ZakupEwidencja)
                                & new FieldCondition.Null("Dokument", true)
                                & new FieldCondition.Contain("DataWplywu", okres), opdb);

                        raport.Sprzedaz =
                            GetCount(session, "DokEwidencja",
                                new FieldCondition.Equal("Typ", Soneta.Core.TypDokumentu.SprzedażEwidencja)
                                & new FieldCondition.Null("Dokument", true)
                                & new FieldCondition.Contain("DataWplywu", okres), opdb);

                        raport.PKE =
                            GetCount(session, "DokEwidencja",
                                new FieldCondition.Equal("Typ", Soneta.Core.TypDokumentu.PKEwidencja)
                                & new FieldCondition.Null("Dokument", true)
                                & new FieldCondition.Contain("DataWplywu", okres), opdb);

                        raport.InneEwidencje =
                            GetCount(session, "DokEwidencja",
                                !(new FieldCondition.In("Typ",
                                    new object[] {
										Soneta.Core.TypDokumentu.ZakupEwidencja,
										Soneta.Core.TypDokumentu.SprzedażEwidencja,
										Soneta.Core.TypDokumentu.PKEwidencja
									}))
                                & new FieldCondition.Null("Dokument", true)
                                & new FieldCondition.Contain("DataWplywu", okres), opdb);

                        raport.Dekrety = GetCount(session, "Dziennik", new FieldCondition.Contain("Data", okres), opdb);
                        raport.Zapisy = GetCount(session, "ZapisyKsiegowe", new FieldCondition.Contain("Data", okres), opdb, "Dekret", "Dziennik");

                        raport.ZaplatyBank = GetCount(session, "Zaplaty",
                            new FieldCondition.Equal("EwidencjaSP.Typ", Soneta.Kasa.TypEwidencjiSP.RachunekBankowy)
                            & new FieldCondition.Contain("DataDokumentu", okres) & new FieldCondition.Null("Raport", false), opdb);

                        raport.ZaplatyKasa = GetCount(session, "Zaplaty",
                            new FieldCondition.Equal("EwidencjaSP.Typ", Soneta.Kasa.TypEwidencjiSP.Kasa)
                            & new FieldCondition.Contain("DataDokumentu", okres) & new FieldCondition.Null("Raport", false), opdb);

                        raport.InneKasowe =
                            GetCount(session, "DokRozliczeniowe", new FieldCondition.Contain("Data", okres), opdb)
                            + GetCount(session, "Delegacje", new FieldCondition.Contain("DataWystawienia", okres), opdb);

                        raport.WyplatyEtat = GetCount(session, "Wyplaty",
                            new FieldCondition.NotEqual("Typ", Soneta.Place.TypWyplaty.Etat)
                            & new FieldCondition.Contain("Data", okres), opdb);

                        raport.WyplatyUmowy = GetCount(session, "Wyplaty",
                            new FieldCondition.NotEqual("Typ", Soneta.Place.TypWyplaty.Umowa)
                            & new FieldCondition.Contain("Data", okres), opdb);

                        raport.OpisAnalityczny = GetCount(session, "OpisAnalityczny",
                            new FieldCondition.Contain("Data", okres) & new FieldCondition.Null("Ewidencja", false),
                            opdb, "Ewidencja", "DokEwidencja");
                    }
                    raportyBaz.Add(raport);
                }
            }
        }

        static int GetCount(Session session, string tableName, RowCondition condition, Operator op)
        {
            return GetCount(session, tableName, condition, op, "", "");
        }

        static int GetCount(Session session, string tableName, RowCondition condition, Operator op, string sourceField, string sourceTable)
        {
            Query.Table q = new Query.Table(tableName);
            q.Distinct = true;
            if (string.IsNullOrEmpty(sourceTable))
                sourceTable = tableName;
            Query.Table src = q;
            if (!string.IsNullOrEmpty(sourceField))
                src = q.Add(new Query.InnerJoin(sourceTable, new FieldCondition.Equal("ID", q, sourceField)));
            Query.Table ci = src.Add(new Query.InnerJoin("ChangeInfos",
                new FieldCondition.Equal("SourceGuid", src, "Guid")
                & new FieldCondition.Equal("Operator", op) & new FieldCondition.Equal("SourceTable", sourceTable)
                & new FieldCondition.Equal("Type", ChangeInfoType.Created)));
            //ci.Condition &= 
            //	new FieldCondition.Equal("Operator", op) & new FieldCondition.Equal("SourceTable",sourceTable)
            //	& new FieldCondition.Equal("Type",ChangeInfoType.Created);
            Query.Count c = new Query.Count("ID");
            c.PropertyName = "Count";
            q += c;
            q.Condition = condition;

            int count = 0;
            foreach (CountQuery iq in session.Execute<CountQuery>(q))
                count += iq.Count;
            return count;
        }		

		readonly Operator op = null;
		public Operator Operator { get{return op;} }
		
		List<RaportBazy> raportyBaz = new List<RaportBazy>();
		public RaportBazy[] RaportyBaz { get { return raportyBaz.ToArray(); } }

		class CountQuery {
			int count;
			public int Count { get { return count; } set { count = value;  } }
		}				
	}

	public class RaportBazy {
        public string Operator { get; set; }
        
        public DBItem DBItem { get; set; }

        public int Zakup { get; set; }

        public int Sprzedaz { get; set; }

        public int PKE { get; set; }

        public int InneEwidencje { get; set; }		

        public int Dekrety { get; set; }

        public int Zapisy { get; set; }

        public int ZaplatyKasa { get; set; }

        public int ZaplatyBank { get; set; }
		
        public int InneKasowe { get; set; }	

        public int WyplatyEtat { get; set; }

        public int WyplatyUmowy { get; set; }

        public int OpisAnalityczny { get; set; }				
	}	

	public class Params : ContextBase {
        public enum GrupowanieWg { Operatorów, BazDanych }

        public Params(Context cx)
            : base(cx)
        {
            if (cx.Contains(typeof(OkresContext)))
                okres = ((OkresContext)cx[typeof(OkresContext)]).Okres;
            dbitems = (DBItem[])GetListDBItems().DataSource;
            operators = GetListOperators(false);
        }

		Operator[] operators = null;
        [Caption("Operatorzy")]
        [Soneta.Tools.Priority(10)]
        public Operator[] Operators
        {
            get { return operators; }
            set { operators = value; }
        }

        public LookupInfo.EnumerableItem GetListOperators()
        {
            return new LookupInfo.EnumerableItem("Operatorzy", GetListOperators(true), new[] { "Name", "FullName" });
        }

        Operator[] GetListOperators(bool standard)
        {
            var arr = new List<Operator>();
            foreach (Operator op in Soneta.Business.Db.BusinessModule.GetInstance(Context).Operators.ByName) {
                if (!op.IsOperatorNet) {
                    if (op.IsStandard && !standard)
                        continue;
                    arr.Add(op);
                }
            }
            return arr.ToArray();
        }

        DBGroup[] dbgroups = null;
        [Caption("Grupy baz danych")]
        [Soneta.Tools.Priority(20)]
        public DBGroup[] DBGroupItems
        {
            get { return dbgroups; }
            set
            {
                dbgroups = value;
                OnDBGroupsChanged();
                OnChanged();
            }
        }
        
        void OnDBGroupsChanged()
        {
            List<DBItem> result = new List<DBItem>(); 
            if (dbgroups != null)
                foreach (DBGroup dbgroup in dbgroups) {
                    foreach (DBGroupItem item in dbgroup.DBGroupItems) {
                        result.Add(item.DBItem);
                    }
                }
            dbitems = result.ToArray();
        }
        
		DBItem[] dbitems = null;
        [Caption("Bazy danych")]
        [Soneta.Tools.Priority(30)]
        public DBItem[] DBItems
        {
            get { return dbitems; }
            set { dbitems = value; }
        }

        public LookupInfo.EnumerableItem GetListDBItems()
        {
            List<DBItem> arr = new List<DBItem>();
            if (dbgroups != null && dbgroups.Length > 0) {
                List<DBItem> result = new List<DBItem>();
                foreach (DBGroup dbgroup in dbgroups) {
                    foreach (DBGroupItem dbi in dbgroup.DBGroupItems) {
                        if (dbi.DBItem.GetObjectRight() != AccessRights.Denied)
                            arr.Add(dbi.DBItem);
                    }
                }
            }
            else {
                foreach (DBItem dbi in BusinessModule.GetInstance(Context).DBItems.ByName) {
                    if (dbi.GetObjectRight() != AccessRights.Denied)
                        arr.Add(dbi);
                }
            }
            return new LookupInfo.EnumerableItem("Bazy danych", arr.ToArray(), new[] { "Name", "Client" });
        }

		FromTo okres = Date.Today.ToYearMonth().ToFromTo();
        [Caption("Okres")]
        [Soneta.Tools.Priority(40)]
        public FromTo Okres
        {
            get { return okres; }
            set { okres = value; }
        }

        GrupowanieWg grupowanie = GrupowanieWg.Operatorów;
        [Caption("Grupowanie wg")]
        [Soneta.Tools.Priority(50)]
        public GrupowanieWg Grupowanie
        {
            get { return grupowanie; }
            set { grupowanie = value; }
        }	
	}
	
</script>

<html>
	<head>
		<title>Raport pracy operatorów</title>
	</head>
	<body>
		<form method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" Landscape="True"></ea:DataContext>
			<ec:reportheader id="ReportHeader1" title="Raport pracy operatorów | (liczba zmian rekordów)  wg {1} | Okres: {0}" runat="server"  />

            <ea:DataRepeater ID="DataRepeater1" runat="server" Height="101px" Width="782px" RowTypeName="Soneta.Business.App.Operator,Soneta.Business" Font-Size="XX-Small">
								<ea:DataLabel ID="labelOperator" DataMember="Operator" runat="server"></ea:DataLabel>
                <ea:Grid ID="Grid1" runat="server" DataMember="RaportyBaz">
                    <Columns>
                        <ea:GridColumn runat="server" Align="Left" ID="FirstColumn" Caption="Baza danych" DataMember="DBItem" Total="Info" />
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dokumenty ewidencji bez dok. źródł. ~ Zakup" DataMember="Zakup" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dokumenty ewidencji bez dok. źródł. ~ Sprzedaż" DataMember="Sprzedaz" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dokumenty ewidencji bez dok. źródł. ~ PKE" DataMember="PKE" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dokumenty ewidencji bez dok. źródł. ~ Inne" DataMember="InneEwidencje" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dziennik ~ Dekrety" DataMember="Dekrety" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Dziennik ~ Zapisy" DataMember="Zapisy" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="EŚP ~ Zapłata kasa" DataMember="ZaplatyKasa" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="EŚP ~ Zapłata bank" DataMember="ZaplatyBank" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="EŚP ~ Inne" DataMember="InneKasowe" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Kadry i płace ~ Wypłaty etat" DataMember="WyplatyEtat" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Kadry i płace ~ Wypłaty umowy" DataMember="WyplatyUmowy" Total="Sum"/>
                        <ea:GridColumn runat="server" Align="Right" Width="10" HideZero="true" Caption="Opis analityczny" DataMember="OpisAnalityczny" Total="Sum"/>
                    </Columns>
                </ea:Grid>
            </ea:DataRepeater>

			<ec:reportfooter id="ReportFooter1" runat="server" >
				<Subtitles>
					<ec:FooterSubtitle runat="server" SubtitleType="OperatorCzas" Width="50" />
					<ec:FooterSubtitle runat="server" SubtitleType="Podpis" Width="50" />
				</Subtitles>
			</ec:reportfooter>
		</form>
	</body>
</html>
